## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "htmlDocumentUtils.tcl"
 #                                    created: 99-07-20 17.17.35 
 #                                last update: 01-11-03 22.31.12 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 3.1.4
 # 
 # Copyright 1996-2001 by Johan Linde
 #  
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ###################################################################
 ##

#===============================================================================
# This file contains procs for the menu items "New Document", "New with Content"
# "New Doc. with Frames", "Document Size", "Document Type", and "Document Index"
#===============================================================================

#===============================================================================
#  New document  #
#===============================================================================

#
# Template for new file: HTML, TITLE, HEAD, BODY or FRAMESET
# Optionally input BASE, LINK, ISINDEX, META and SCRIPT in HEAD.
proc html::NewDocument {} {html::NewTemplate BODY}
proc html::NewwithContent {} {html::NewTemplate BODY 1}
proc html::NewDoc.withFrames {} {html::NewTemplate FRAMESET}

proc html::NewTemplate {doctype {withContent 0}} {
	global htmlCurSel htmlIsSel HTMLmodeVars html::HeadElements html::HideExtensions html::HideDeprecated
	global html::LastDocType html::LastFrameDocType html::LastNewHP html::LastNewTempl

	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set indentHTML [lcontains HTMLmodeVars(indentElements) HTML]
	set indentHEAD [lcontains HTMLmodeVars(indentElements) HEAD]
	set indentBODY [lcontains HTMLmodeVars(indentElements) $doctype]
	set headIndent ""
	set bodyIndent ""
	set htmlIndent ""
	if {$indentHTML} {
		append htmlIndent "\t"
		append headIndent "\t"
		append bodyIndent "\t"
	}
	if {$indentHEAD} {append headIndent "\t"}
	if {$indentBODY} {append bodyIndent "\t"}
	
	if {![info exists html::LastNewHP]} {set html::LastNewHP " "}
	if {![info exists html::LastNewTempl]} {set html::LastNewTempl " "}
	
	if {$doctype == "FRAMESET"} {
		set htxt "New document with frames"
	} else {
		set htxt "New document"
	}
	
	set box "[dialog::title {Choose template} 300] -t {Home Page:} 10 [expr {40 - $diff}] 100 [expr {55 - $diff}] \
	  -t {Template:} 10 [expr {70 - $diff}] 100 [expr {85 - $diff}]"
	set j 0
	if {!$withContent} {
		set fname ""
		if {[llength [winNames]] && [html::IsEmptyFile]} {
			set fname [win::StripCount [lindex [winNames] 0]]
		}
		append box " -t {File name:} 10 [expr {100 - $diff}] 100 [expr {115 - $diff}] \
		  -e [list $fname] 110 [expr {100 - $diff}] 340 [expr {115 - $diff}]"
		incr j
	}
	set hpflds ""
	set sites ""
	foreach hp $HTMLmodeVars(homePages) {
		lappend hpflds [lindex $hp 0]
		lappend sites "[lindex $hp 1][lindex $hp 2]"
	}
	lappend box -m [concat [list ${html::LastNewHP}] $sites] 110 [expr {40 - $diff}] 350 [expr {60 - $diff}]
	set i 0
	incr j 3
	foreach hp $hpflds {
		foreach f $HTMLmodeVars(templateFolders) {
			if {[lindex $f 0] == $hp} {
				set tmpls($hp) {{ }}
				set tmplindex($hp) $j
				set tmplfld($hp) [lindex $f 1]
				incr j
				foreach t [glob -nocomplain -types TEXT -dir [lindex $f 1] *] {
					lappend tmpls($hp) [file tail $t]
				}
				lappend box -n [lindex $sites $i] -m [concat [list ${html::LastNewTempl}] $tmpls($hp)] 110 [expr {70 - $diff}] 350 [expr {90 - $diff}]
				break
			}
		}
		incr i
	}

	set values [eval [concat dialog -w 360 -h [expr {160 - $diff}] -b OK 280 [expr {130 - $diff}] 345 [expr {150 - $diff}] \
	  -b Cancel 195 [expr {130 - $diff}] 260 [expr {150 - $diff}] $box]]
	if {[lindex $values 1]} {return}
	
	set hpfld [lindex $hpflds [lsearch -exact $sites [set html::LastNewHP [lindex $values [expr {2 + !$withContent}]]]]]
	if {[info exists tmpls($hpfld)] && [set html::LastNewTempl [lindex $values $tmplindex($hpfld)]] != " "} {
		set template [file join $tmplfld($hpfld) ${html::LastNewTempl}]
	}
	
	set bodyText ""
	if {$withContent && [llength [winNames]]} {
		set bodyText [getText [minPos] [maxPos]]
		deleteText [minPos] [maxPos]
	} else {
		if {![llength [winNames]] || [set filename [string trim [lindex $values 2]]] == ""} {set filename Untitled.html}
		if {![llength [winNames]] || ![html::IsEmptyFile] || [win::StripCount [lindex [winNames] 0]] != $filename} {
			new -n $filename -m HTML
		}
	} 
	
	if {$indentHTML || $indentBODY} {regsub -all "\r" "\r$bodyText" "\r$bodyIndent" bodyText}
	
	if {[info exists template]} {
		if {[catch {file::readAll $template} templText]} {
			alertnote "Could not read template file."
		} else {
			insertText $templText
		}
	}

	if {![catch {search -s -f 1 -r 0 -i 1 -m 0 {#CONTENT#} [minPos]} res]} {
		replaceText [lindex $res 0] [lindex $res 1] $bodyText
	} elseif {![catch {search -s -f 1 -r 0 -i 1 -m 0 [html::CloseElem $doctype] [minPos]} res] || 
	  ![catch {search -s -f 1 -r 0 -i 1 -m 0 {</HTML>} [minPos]} res]} {
		goto [lindex $res 0]
		elec::Insertion $bodyText "\r\r"
	} else {
		goto [maxPos]
		elec::Insertion $bodyText "\r\r"
	}
	
	if {[catch {search -s -f 0 -r 0 -i 1 -m 0 {</HTML>} [maxPos]}]} {
		goto [maxPos]
		elec::Insertion [html::CloseElem HTML]
	}
	set htmlpos [search -s -f 0 -r 0 -i 1 -m 0 {</HTML>} [maxPos]]
	if {[catch {search -s -f 0 -r 0 -i 1 -m 0 "</$doctype>" [lindex $htmlpos 0]} res]} {
		goto [lindex $htmlpos 0]
		elec::Insertion "$htmlIndent[html::CloseElem $doctype]\r\r"
	}
	
	set docTitle ""
	if {![catch {html::FindFirstOccurance {<title[^<>]*>[^<>]*</title>} [minPos]} res]} {
		regexp -nocase {<title[^<>]*>([^<>]*)</title>} [eval getText $res] "" docTitle
	}
		
	
	set inHead "0 0 [list $docTitle]"
	foreach elem ${html::HeadElements} {
		lappend inHead 0
	}
	if {[set dt [html::FindDoctype]] != ""} {
		switch $dt {
			transitional -
			frameset {lappend inHead 0 1 0}
			strict {lappend inHead 0 0 1}
		}
	} elseif {$doctype == "BODY" && [info exists html::LastDocType]} {
		lappend inHead [expr {${html::LastDocType} == "none"}] \
		  [expr {${html::LastDocType} == " Transitional"}] \
		  [expr {${html::LastDocType} == ""}]
	} elseif {$doctype == "FRAMESET" && [info exists html::LastFrameDocType]} {
		lappend inHead [expr {${html::LastFrameDocType} == "none"}] \
		  [expr {${html::LastFrameDocType} == " Frameset"}]
	} else {
		lappend inHead 0 1 0
	}
	set first 1
	while {$first || $docTitle == ""} {
		set first 0
		# Construct the dialog box.
		set box "[dialog::title $htxt 300] -t {TITLE} 10 [expr {40 - $diff}] 60 [expr {55 - $diff}] \
		-e [list [lindex $inHead 2]] 70 [expr {40 - $diff}] 390 [expr {55 - $diff}] \
		-t {Select the elements you want in the document\'s HEAD} 10 [expr {70 - $diff}] 390 [expr {85 - $diff}]"
		set hpos [expr {100 - $diff}]
		set wpos 10
		set i 3
		foreach elem ${html::HeadElements} {
			append box " -c $elem [lindex $inHead $i] $wpos $hpos [expr {$wpos + 100}] [expr {$hpos + 15}]"
			incr wpos 100
			if {$wpos > 110} {set wpos 10; incr hpos 20}
			incr i
		}
		if {$wpos > 10} {incr hpos 20}
		incr hpos 10
		append box " -t {Document type declaration:} 220 [expr {100 - $diff}] 405 [expr {115 - $diff}]"
		append box " -r None [lindex $inHead $i] 220 [expr {120 - $diff}] 390 [expr {135 - $diff}]"
		if {$doctype == "BODY"} {
			append box " -r Transitional [lindex $inHead [expr {$i + 1}]] 220 [expr {140 - $diff}] 390 [expr {155 - $diff}]"
			append box " -r Strict [lindex $inHead [expr {$i + 2}]] 220 [expr {160 - $diff}] 390 [expr {175 - $diff}]"
		} else {
			append box " -r Frameset [lindex $inHead [expr {$i + 1}]] 220 [expr {140 - $diff}] 390 [expr {155 - $diff}]"
		}
		set inHead [eval [concat dialog -w 410 -h [expr {$hpos + 30}] \
		-b OK 330 $hpos 395 [expr {$hpos + 20}] \
		-b Cancel 245 $hpos 310 [expr {$hpos + 20}] $box]]
		if {[lindex $inHead 1]} {return}
		set docTitle [string trim [lindex $inHead 2]]
		if {$docTitle == ""} {
			alertnote "A document title is required."
		}
	}
	
	if {![lindex $inHead $i]} {
		if {$doctype == "BODY"} {
			if {[lindex $inHead [expr {$i + 1}]]} {set dtd " Transitional"; set html::HideExtensions 1}
			if {[lindex $inHead [expr {$i + 2}]]} {set dtd ""; set html::HideDeprecated 1}
		} else {
			set dtd " Frameset"
		}
		html::SetDis
		set text "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01$dtd//EN\">\r"
		if {![catch {search -s -f 1 -r 1 -i 1 -m 0 {<!doctype[^<>]+>} [minPos]} res]} {
			replaceText [lindex $res 0] [lindex $res 1] $text
		} else {
			goto [minPos]
			insertText $text "\r"
		}
		if {$doctype == "BODY"} {
			set html::LastDocType $dtd
		} else {
			set html::LastFrameDocType $dtd
		}
	} else {
		if {![catch {search -s -f 1 -r 1 -i 1 -m 0 {<!doctype[^<>]+>} [minPos]} res]} {
			eval deleteText $res
		}
		if {$doctype == "BODY"} {		
			set html::LastDocType none
		} else {
			set html::LastFrameDocType none
		}
	}
	set pos [minPos]
	if {![catch {search -s -f 1 -r 1 -i 1 -m 0 {<!doctype[^<>]+>} [minPos]} res]} {
		set pos [lindex $res 1]
		if {[is::Whitespace [getText $pos [nextLineStart $pos]]]} {set pos [nextLineStart $pos]}
	}
	if {![catch {html::FindFirstOccurance {<html[^<>]*>} $pos} res]} {
		goto [pos::math [lindex $res 0] + 1]
		html::EditTag 1
		set pos [lindex $res 1]
	} else {
		goto $pos
		insertText [html::OpenElem HTML "" 0] "\r"
		set pos [getPos]
	}
	if {![catch {html::FindFirstOccurance {<head[^<>]*>} $pos} res]} {
		goto [pos::math [lindex $res 0] + 1]
		html::EditTag 1
		set pos [lindex $res 1]
	} else {
		goto $pos
		elec::Insertion $htmlIndent [html::OpenElem HEAD "" 0] "\r"
		set pos [getPos]
	}
	if {![catch {html::FindFirstOccurance {<title[^<>]*>[^<>]*</title>} $pos} res]} {
		regsub -nocase "(<title\[^<>\]*>)\[^<>\]*(</title>)" [eval getText $res] "\\1$docTitle\\2" dt
		replaceText [lindex $res 0] [lindex $res 1] $dt
		goto [pos::math [lindex $res 0] + 1]
		html::EditTag 1
		set pos [lindex [html::FindFirstOccurance "</title>" $pos] 1]
	} else {
		goto $pos
		insertText $docTitle
		select $pos [pos::math $pos + [string length $docTitle]]
		html::Tag TITLE
		set pos [getPos]
	}
	if {[catch {html::FindFirstOccurance {</head>} $pos} res]} {
		while {![catch {search -s -f 1 -r 1 -i 1 -m 0 {<!--|<[^<>]+>} $pos} res]} {
			set tagtxt [eval getText $res]
			if {$tagtxt == "<!--"} {
				# Comment
				if {![catch {search -s -f 1 -r 0 -m 0 -- {-->} [lindex $res 0]} res]} {
					set pos [lindex $res 1]
				} else {
					set pos [maxPos]
				}
				continue
			}
			if {![regexp -nocase "<([join ${html::HeadElements} |]|/SCRIPT|/STYLE|/OBJECT)(\[ \t\r\n\]+|>)" $tagtxt]} {break}
			set pos [lindex $res 1]
		}
		if {[is::Whitespace [getText $pos [nextLineStart $pos]]]} {set pos [nextLineStart $pos]}
		goto $pos
		elec::Insertion "\r" $htmlIndent [html::CloseElem HEAD] "\r"
	}
	
	for {set i 0} {$i < [llength  ${html::HeadElements}]} {incr i} {
		if {[lindex $inHead [expr {$i + 3}]]} {
			set he [lindex ${html::HeadElements} $i]
			if {$he == "ISINDEX" && $dtd == ""} {alertnote "ISINDEX cannot be used in strict HTML."; continue}
			if {($he == "ISINDEX" || $he == "BASE") && ![catch {html::FindFirstOccurance "<$he\[^<>\]*>" [minPos]} res]} {
				goto [pos::math [lindex $res 0] + 1]
				html::EditTag 1
			} else {
				set pos [lindex [html::FindFirstOccurance {</head>} [minPos]] 0]
				goto $pos
				html::Tag $he				
				if {($he == "STYLE" || $he == "SCRIPT" || $he == "OBJECT") && $HTMLmodeVars(useTabMarks)} {
					insertText 
					catch {ring::+}
				} 
			}
		}
	}
	
	if {![catch {html::FindFirstOccurance "<$doctype\[^<>\]*>" [minPos]} res]} {
		goto [pos::math [lindex $res 0] + 1]
		html::EditTag 1
	} else {
		set pos [lindex [html::FindFirstOccurance {</head>} [minPos]] 1]
		if {[is::Whitespace [getText $pos [nextLineStart $pos]]]} {set pos [nextLineStart $pos]}
		goto $pos
		elec::Insertion "\r" $htmlIndent [html::OpenElem $doctype "" 0] "\r"
	}
	refresh
	html::ActivateHook
	goto [minPos]
	ring::+
}

#===============================================================================
#  Document type  #
#===============================================================================

proc html::DocumentType {} {
	set dt [html::FindDoctype]
	set m0 [lindex [set types {Strict Strict Transitional Frameset}] [lsearch -exact {{} strict transitional frameset} $dt]]
	set diff 0
	if {[info tclversion] >= 8.0} {set diff 20}
	set box [dialog::title {Document type declaration} 250]
	lappend box -m [concat $m0 [lrange $types 1 end]] 10 [expr {45 - $diff}] 190 [expr {65 - $diff}] \
	  -b OK 170 [expr {90 - $diff}] 235 [expr {110 - $diff}] -b Cancel 85 [expr {90 - $diff}] 150 [expr {110 - $diff}]
	set v [eval [concat dialog -w 250 -h [expr {120 - $diff}] $box]]
	if {[lindex $v 2]} {return}
	set pos [pos::diff [getPos] [minPos]]
	goto [minPos]
	switch [lindex $v 0] {
		Strict {set dtd {}}
		Transitional {set dtd " Transitional"}
		Frameset {set dtd " Frameset"}
	}
	set txt "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01$dtd//EN\">"
	if {![catch {search -s -f 1 -i 1 -m 0 -r 1 {<!DOCTYPE[^<>]+>} [minPos]} res]} {
		eval deleteText $res
	} else {
		set res "[minPos] [minPos]"
	}
	insertText $txt [html::CloseCR]
	goto [pos::math [minPos] + $pos + [string length $txt] - [pos::diff [lindex $res 0] [lindex $res 1]]]
	html::ActivateHook
}

#===============================================================================
#  Document size  #
#===============================================================================

# Calculate the total size of a document including images etc.
proc html::DocumentSize {} {
	# Get path to this window.
	if {[set thisURL [html::ThisFilePath 3]] == ""} {return}
	set exp1 {<!--|[ \t\n\r]+(DATA|CLASSID|SRC|LOWSRC|DYNSRC|BACKGROUND|USEMAP)[ \t\n\r]*=[ \t\n\r]*("[^"]+"|'[^']+'|[^ \t\n\r"'>]+)}
	set exp2 {[ \t\r\n]+(url)\([ \t\r\n]*("[^"]+"|'[^']+'|[^ \t\n\r"'\)]+)[ \t\r\n]*\)}
	set commStart1 "<!--"
	set commEnd1 "-->"
	set commStart2 {/*}
	set commEnd2 {*/}
	set size 0
	set counted {}
	set external 0
	set notfound 0
	for {set i 1} {$i < 3} {incr i} {
		set pos [minPos]
		set exp [set exp$i]
		set commStart [set commStart$i]
		set commEnd [set commEnd$i]
		while {![catch {search -s -f 1 -i 1 -m 0 -r 1 $exp $pos} res]} {
			set restxt [eval getText $res]
			# Comment?
			if {$restxt == $commStart} {
				if {![catch {search -s -f 1 -m 0 -i 0 -r 0 -- $commEnd [lindex $res 1]} res]} {
					set pos [lindex $res 1]
					continue
				} else {
					break
				}
			}
			# Get path to link.
			regexp -nocase $exp $restxt dum1 dum2 linkTo
			set linkTo [html::URLunEscape [string trim $linkTo "\"' \t\r\n"]]
			if {[string index $linkTo 0] != "#"} {
				if {![catch {lindex [html::PathToFile [lindex $thisURL 0] [lindex $thisURL 1] [lindex $thisURL 2] [lindex $thisURL 3] $linkTo] 0} linkToPath]} {
					if {[file exists $linkToPath] && ![file isdirectory $linkToPath]} {
						if {![lcontains counted $linkToPath]} {
							getFileInfo $linkToPath arr
							incr size $arr(datalen)
							lappend counted $linkToPath
						}
					} else {
						set notfound 1
					}
				} else {
					set external 1
				}
			}
			set pos [lindex $res 1]
		}
	}
	incr size [pos::diff [maxPos] [minPos]]
	if {$size > 1000} {
		set size "[expr {$size /1024}] kB"
	} else {
		append size " bytes"
	}
	set txt "Total size: $size."
	if {$notfound} {append etxt "Some files not found. "}
	if {$external} {append etxt "External sources excluded."}
	if {$notfound || $external} {append txt " ([string trim $etxt])"}
	alertnote $txt
}


#===============================================================================
#   Document index  #
#===============================================================================

proc html::DocumentIndex {} {
	global HTMLmodeVars
	
	set liIndent ""
	set indLists [lcontains HTMLmodeVars(indentElements) UL]
	set indItems [lcontains HTMLmodeVars(indentElements) LI]
	if {$indLists} {set liIndent "\t"}
	html::indentCR UL LI
	if {![catch {search -s -f 1 -r 1 -m 0 -i 1 {<!--[ \t\r\n]+#DOCINDEX[ \t\r\n]+[^>]+>} [minPos]} begin] &&
	![catch {search -s -f 1 -r 1 -m 0 -i 1 {<!--[ \t\r\n]+/#DOCINDEX[ \t\r\n]+[^>]+>} [lindex $begin 1]} endind] &&
	[regexp -nocase {TYPE=\"(UL|PRE,[0-9]+)\"} [getText [lindex $begin 0] [lindex $begin 1]] dum type]} {
		if {![regexp -nocase {DEPTH=\"([1-6])\"} [getText [lindex $begin 0] [lindex $begin 1]] dum depth]} {set depth 6}
		set type [string toupper $type]
		if {$type != "UL"} {
			regexp {(PRE),([0-9]+)} $type dum type indent
			set indStr [string range "                                  " 1 $indent]
		}
		set replace 1
	} else {
		set replace 0
		set values [list 0 0 6 PRE 3]
		set diff 0
		if {[info tclversion] >= 8.0} {set diff 20}
		while {1} {
			set box "[dialog::title {Document index} 250] \
			  -t {Header depth} 10 [expr {40 - $diff}] 100 [expr {60 - $diff}] \
			  -e [list [lindex $values 2]] 105 [expr {40 - $diff}] 125 [expr {55 - $diff}] \
			  -m {[list [lindex $values 3]] PRE UL} 10 [expr {70 - $diff}] 65 [expr {90 - $diff}] \
			  -n PRE -t Indent 70 [expr {70 - $diff}] 120 [expr {90 - $diff}] \
			  -e [list [lindex $values 4]] 125 [expr {70 - $diff}] 165 [expr {85 - $diff}] \
			  -t characters 170 [expr {70 - $diff}] 290 [expr {90 - $diff}]"
			set values [eval [concat dialog -w 300 -h [expr {130 - $diff}] \
			  -b OK 220 [expr {100 - $diff}] 285 [expr {120 - $diff}] \
			  -b Cancel 135 [expr {100 - $diff}] 200 [expr {120 - $diff}] $box]]
			set depth [lindex $values 2]
			set type [lindex $values 3]
			if {[lindex $values 1]} {return}
			if {[expr {($depth > 0) && ($depth < 7)}]} {
			    if {$type == "PRE"} {
				    set indent [lindex $values 4]
				    if {[is::PositiveInteger $indent]} {
					    set indStr [string range "                                  " 1 $indent]
					    break
				} else {
					alertnote "The number of characters to indent must be specified."
				}
			    } else {
				    break
			    }
			} else {
			    alertnote "The header depth must be between 1 and 6"
			}
		}

	}

	set pos [minPos]
	set exp "<\[Hh\]\[1-$depth\]\[^<>\]*>"
	set exp2 "</\[Hh\]\[1-$depth\]>"
	set indLevel 1
	set headSize 0
	set toc "\r\r<[html::SetCase $type]>"
	set cr 0
	set curr ""
	while {![catch {search -s -f 1 -r 1 -m 0 -i 0 $exp $pos} rs] && 
	![catch {search -s -f 1 -r 1 -m 0 -i 0 $exp2 [lindex $rs 1]} res]} {
		set start [lindex $rs 0]
		set end [lindex $res 1]
		set text [getText $start $end]
		set thisSize [getText [pos::math $start + 2] [pos::math $start + 3]]
		set text2 [getText [lindex $rs 1] [lindex $res 0]]
		regsub -all "\[\t\r\n\]+" $text " " text
		# remove all tags from text
		set headtext [string trim [html::TagStrip $text]]
		# Remove " from text.
		regsub -all "\"" $headtext "" headtext
		# Check if there is already an anchor
		if {[regexp -nocase {<A[ \t\r\n]+[^<>]*NAME[ \t\r\n]*=[ \t\r\n]*(\"[^\">]+\"|'[^'>]+'|[^ \t\n\r>]+)} $text2 dum anchor]} {
			set anchor [string trim $anchor "\"'"]
		} else {
			# Insert an anchor
			set anchor [string trim [string range $headtext 0 15]]
			# Make sure a &xxx; is not chopped.
			if {[set amp [string last & $anchor]] > [set semi [string last \; $anchor]]} {
				set rest [string range $headtext 16 end]
				append anchor [string range $rest 0 [string first \; $rest]]
			}
			# Is there an <A> tag?
			if {[regexp -nocase -indices {<A([ \t\r\n]+[^<>]+>|>)} $text2 atag]} {
				set text3 " [html::SetCase NAME]=\"$anchor\""
				replaceText [set blah [pos::math [lindex $rs 1] + [lindex $atag 0] + 2]] $blah $text3
				set end [pos::math $end + [string length $text3]]
			} else {
				set text3 "<[html::SetCase {A NAME}]=\"$anchor\">$text2[html::CloseElem A]"
				replaceText [lindex $rs 1] [lindex $res 0] $text3
				set end [pos::math $end + [string length $text3] - [string length $text2]]
			}
		}
		
		if {!$headSize} {
			# first header
			set headSize $thisSize
		} elseif {$thisSize > $headSize && $headSize} {
			# new list
			for {set i $headSize} {$i < $thisSize} {incr i} { 
				if {$type == "UL"} {
					html::crBefore $blBefUL $crBefUL toc $liIndent cr curr [html::SetCase <UL>]
					html::crAfter $blAftUL $crAftUL toc liIndent cr curr 0 $indLists
				}
			}
			incr indLevel [expr {$thisSize - $headSize}]
			set headSize $thisSize
		} elseif {$thisSize < $headSize && $indLevel} {
			# close a list
			for {set i $thisSize} {$i < $headSize && $indLevel > 1} {incr i} {
				if {$type == "UL"} {
					html::crBefore ${blBef/UL} ${crBef/UL} toc $liIndent cr curr [html::CloseElem UL]
					html::crAfter ${blAft/UL} ${crAft/UL} toc liIndent cr curr 1 $indLists
				}
				incr indLevel -1
			}
			set headSize $thisSize
		}
		if {$type == "UL"} {
			html::crBefore $blBefLI $crBefLI toc $liIndent cr curr [html::SetCase <LI>]
			html::crAfter $blAftLI $crAftLI toc liIndent cr curr 0 $indItems
		} else {
			append toc \r
			for {set i 1} {$i < $indLevel} {incr i} {
				append toc $indStr
			}
		}
		if {$type == "UL"} {
			append curr [html::prepareForBreaking "[html::SetCase {<A HREF}]=\"#$anchor\">$headtext[html::CloseElem A]"]
		} else {
			append toc "[html::SetCase {<A HREF}]=\"#$anchor\">$headtext[html::CloseElem A]"
		}
		if {$type == "UL" && [lcontains HTMLmodeVars(optionalClosing) LI]} {
			html::crBefore ${blBef/LI} ${crBef/LI} toc $liIndent cr curr [html::CloseElem LI]
			html::crAfter ${blAft/LI} ${crAft/LI} toc liIndent cr curr 1 $indItems
		}
		set pos $end
	}
	if {$type == "UL"} {
		for {set i $indLevel} {$i > 0} {incr i -1} {
			html::crBefore ${blBef/UL} ${crBef/UL} toc $liIndent cr curr [html::CloseElem UL]
			html::crAfter ${blAft/UL} ${crAft/UL} toc liIndent cr curr 1 $indLists
		}
		if {$curr != ""} {
			if {![is::Whitespace $curr]} {append toc $liIndent}
			append toc [html::BreakIntoLines $curr $liIndent]
		}
	} else {
		append toc "\r[html::CloseElem PRE]\r\r"
	}
	if {$replace} {
		if {[pos::compare $pos == [minPos]]} {set toc ""}
		# Find list again in case it has moved.
		set begin [search -s -f 1 -r 1 -m 0 -i 1 {<!--[ \t\r\n]+#DOCINDEX[ \t\r\n]+[^>]+>} [minPos]]
		set endind [search -s -f 1 -r 1 -m 0 -i 1 {<!--[ \t\r\n]+/#DOCINDEX[ \t\r\n]+[^>]+>} [lindex $begin 1]]
		if {$type == "PRE"} {
			replaceText  [lindex $begin 1] [lindex $endind 0] [string trimright $toc] \r\r
		} else {
			elec::ReplaceText [lindex $begin 1] [lindex $endind 0] [string trimright $toc] \r\r
		}
	} else {
		set tt ""
		if {[pos::compare $pos == [minPos]]} {alertnote "Empty index."; return}
		if {$type == "PRE"} {
			set tt ",$indent"
			set ind ""
		}
		append toctext [html::OpenCR 1] [html::SetCase "<!-- #DOCINDEX TYPE=\"$type$tt\" DEPTH=\"$depth\" -->"] \
		  [string trimright $toc] \r\r [html::SetCase "<!-- /#DOCINDEX -->"] [html::CloseCR2 [getPos]]
		if {$type == "PRE"} {
			insertText $toctext
		} else {
			html::elecInsertion toctext
		}
	}
}
